/* Wiktor Zychla, 2003 */
using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{
  // klasa do porwnywania elementw ListView
  // wg. wskazanej kolumny
  public class MyLVItemSorter : IComparer
  {
    int kolumna; // kolumna wg. ktrej sortujemy

    public MyLVItemSorter( int kolumna )
    {
      this.kolumna = kolumna;
    }

    public int Compare( object o1, object o2 )
    {
      ListViewItem l1 = o1 as ListViewItem;
      ListViewItem l2 = o2 as ListViewItem;

      return string.Compare( l1.SubItems[ kolumna ].Text,
                             l2.SubItems[ kolumna ].Text );
    }
  }

  public class CMainForm : Form
  {   
    ListView lstItems;

    void InitListViewElements()
    {
      string[] sHeaders = 
        new string[] { "Imi", "Nazwisko", "Data urodzenia" };
      ListViewItem li;
     
      // nagwki 
      lstItems.Columns.Clear();
      foreach ( string s in sHeaders )
        lstItems.Columns.Add( s, 60, HorizontalAlignment.Left ); 
      
      // elementy
      li = lstItems.Items.Add( "Jan" );     
      li.SubItems.Add( "Kowalski" );
      li.SubItems.Add( "1971-05-05" );

      li = lstItems.Items.Add( "Adam" );
      li.SubItems.Add( "Malinowski" );
      li.SubItems.Add( "1975-02-13" );

      li = lstItems.Items.Add( "Zbigniew" );
      li.SubItems.Add( "Abacki" );
      li.SubItems.Add( "1972-05-11" );

      // dopasuj szerokoci kolumn
      foreach ( ColumnHeader ch in lstItems.Columns )
        ch.Width = -2;
    }

    // po kliku w kolumn ListView ustal sortowanie wg. tej kolumny
    void LV_ColumnClick( object sender, ColumnClickEventArgs e )
    {
      lstItems.ListViewItemSorter = new MyLVItemSorter( e.Column );
    }

    public CMainForm()
    {
      lstItems      = new ListView();
      lstItems.Dock = DockStyle.Fill;
      lstItems.FullRowSelect = true;
      lstItems.GridLines = true;
      lstItems.View      = System.Windows.Forms.View.Details;       
      lstItems.ColumnClick += new ColumnClickEventHandler( LV_ColumnClick );
     
      this.Controls.Add( lstItems );

      InitListViewElements(); 
    } 

    public static void Main()
    {
      Application.Run( new CMainForm() );
    }
  }
}
